/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.servlet;

import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.getsentry.raven.Raven;

public class RavenServletRequestListener
implements ServletRequestListener {
    private static final Logger logger = LoggerFactory.getLogger(RavenServletRequestListener.class);
    private static final ThreadLocal<HttpServletRequest> THREAD_REQUEST = new ThreadLocal();

    public static HttpServletRequest getServletRequest() {
        return THREAD_REQUEST.get();
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        THREAD_REQUEST.remove();
        try {
            Raven raven = Raven.getStoredInstance();
            if (raven != null) {
                raven.getContext().clear();
            }
        }
        catch (Exception e) {
            logger.error("Error clearing RavenContext state.", e);
        }
    }

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
        ServletRequest servletRequest = servletRequestEvent.getServletRequest();
        if (servletRequest instanceof HttpServletRequest) {
            THREAD_REQUEST.set((HttpServletRequest)servletRequest);
        }
    }
}

