/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.repository;

import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoPrefixV1 {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepoPrefixV1.class);
    private static final List<String> PREFIXES;
    private static final List<String> CDN_PREFIXES;

    public static List<String> prefixesCdnFirst() {
        return Collections.unmodifiableList(RepoPrefixV1.combine(CDN_PREFIXES, PREFIXES));
    }

    public static List<String> prefixesCdnLast() {
        return Collections.unmodifiableList(RepoPrefixV1.combine(PREFIXES, CDN_PREFIXES));
    }

    public static List<String> prefixes() {
        return PREFIXES;
    }

    public static List<String> cdnPrefixes() {
        return CDN_PREFIXES;
    }

    private static <T> List<T> shuffle(List<T> list) {
        Collections.shuffle(list);
        return list;
    }

    private static List<String> getList(Properties properties, String key, List<String> fallbackValue) {
        String value = properties.getProperty(key);
        if (value == null) {
            return fallbackValue;
        }
        return Arrays.asList(value.split(","));
    }

    @SafeVarargs
    public static List<String> combine(List<String> ... lists) {
        ArrayList<String> combined = new ArrayList<String>();
        for (List<String> list : lists) {
            combined.addAll(list);
        }
        return combined;
    }

    static {
        Properties props = new Properties();
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(RepoPrefixV1.class.getResourceAsStream("repositories_v1.properties")), StandardCharsets.UTF_8);){
            props.load(reader);
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't load internal repo list: ", e);
        }
        List<String> domains = RepoPrefixV1.getList(props, "domains", Arrays.asList("llaun.ch", "lln4.ru"));
        List prefixes = RepoPrefixV1.combine(RepoPrefixV1.shuffle(RepoPrefixV1.getList(props, "eu_prefixes", Collections.singletonList("eu1"))), RepoPrefixV1.shuffle(RepoPrefixV1.getList(props, "ru_prefixes", Collections.singletonList("ru1")))).stream().flatMap(zone -> Stream.of(domains.stream().map(domain -> String.format(Locale.ROOT, "https://%s", domain)), domains.stream().map(domain -> String.format(Locale.ROOT, "https://%s.%s", zone, domain))).flatMap(Function.identity())).collect(Collectors.toList());
        CDN_PREFIXES = RepoPrefixV1.getList(props, "cdn_prefixes", Collections.singletonList("https://cdn.turikhay.ru/lln4"));
        PREFIXES = Collections.unmodifiableList(prefixes);
    }
}

