/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.portals;

import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import ru.turikhay.tlauncher.portals.Portal;

public class PortalCombiner
implements Portal {
    private final Collection<Portal> portals;

    public PortalCombiner(Collection<Portal> portals) {
        this.portals = portals;
    }

    public PortalCombiner(Portal ... portals) {
        this(Arrays.asList(portals));
    }

    @Override
    public boolean openURI(URI uri) {
        for (Portal portal : this.portals) {
            if (!portal.openURI(uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean openFile(Path path) {
        for (Portal portal : this.portals) {
            if (!portal.openFile(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean openDirectory(Path path) {
        for (Portal portal : this.portals) {
            if (!portal.openDirectory(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Portal.ColorScheme getColorScheme() {
        for (Portal portal : this.portals) {
            Portal.ColorScheme colorScheme = portal.getColorScheme();
            if (colorScheme == Portal.ColorScheme.NO_PREFERENCE) continue;
            return colorScheme;
        }
        return Portal.ColorScheme.NO_PREFERENCE;
    }
}

