/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui.message;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import ru.turikhay.tlauncher.bootstrap.ui.message.Message;
import ru.turikhay.tlauncher.bootstrap.ui.message.MessagePanel;
import ru.turikhay.tlauncher.bootstrap.ui.message.MessageWindow;

public class MessageHost {
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private final WindowAdapter listener = new WindowAdapter(){

        @Override
        public void windowClosed(WindowEvent e) {
            MessageHost.this.closeLatch.countDown();
        }
    };
    private MessageWindow window;
    private String title;

    public void setTitle(String title) {
        SwingUtilities.invokeLater(() -> {
            this.title = title;
            if (this.window != null) {
                this.window.setTitle(title);
            }
        });
    }

    public void showMessage(Message message) {
        SwingUtilities.invokeLater(() -> this.setMessage(message));
    }

    public void waitForClose() throws InterruptedException {
        this.closeLatch.await();
    }

    public void close() {
        SwingUtilities.invokeLater(() -> {
            if (this.window != null) {
                this.window.dispose();
            }
        });
    }

    private void setMessage(Message message) {
        MessageWindow window = this.window;
        this.window = null;
        this.destroyOldWindow(window);
        this.createNewWindow(message);
    }

    private void destroyOldWindow(MessageWindow oldWindow) {
        if (oldWindow == null) {
            return;
        }
        oldWindow.removeWindowListener(this.listener);
        oldWindow.dispose();
    }

    private void createNewWindow(Message message) {
        MessagePanel panel = new MessagePanel(message);
        MessageWindow window = new MessageWindow(this, panel);
        window.addWindowListener(this.listener);
        this.window = window;
        window.setTitle(this.title);
        window.setVisible(true);
        window.requestFocus();
    }
}

