/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui.flatlaf;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.IntelliJTheme;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.UIManager;
import ru.turikhay.tlauncher.bootstrap.bridge.FlatLafConfiguration;
import ru.turikhay.tlauncher.bootstrap.ui.UserInterface;
import ru.turikhay.tlauncher.bootstrap.ui.flatlaf.Addon;
import ru.turikhay.tlauncher.bootstrap.ui.flatlaf.themedetector.ThemeDetector;
import ru.turikhay.tlauncher.bootstrap.util.U;

public class FlatLaf {
    public static void initialize(FlatLafConfiguration config) {
        if (config.isEnabled()) {
            FlatLafConfiguration.Theme theme = config.getSelected().orElse(FlatLaf.detectTheme());
            FlatLaf.setUIProperties(config.getUiPropertiesFiles().get((Object)theme));
            FlatLaf.setLaf(theme, config.getThemeFiles().get((Object)theme));
        } else {
            FlatLaf.log("FlatLaf is not enabled. Skipping initialization");
        }
    }

    private static FlatLafConfiguration.Theme detectTheme() {
        FlatLaf.log("Detecting system theme");
        return ThemeDetector.detectTheme();
    }

    private static void setLaf(FlatLafConfiguration.Theme theme, String themeFile) {
        com.formdev.flatlaf.FlatLaf laf = null;
        boolean useSystemTheme = false;
        if (themeFile != null) {
            if (themeFile.startsWith(":")) {
                switch (themeFile.substring(1)) {
                    case "darcula": {
                        laf = new FlatDarculaLaf();
                        break;
                    }
                    case "dark": {
                        laf = new FlatDarkLaf();
                        break;
                    }
                    case "intellij": {
                        laf = new FlatIntelliJLaf();
                        break;
                    }
                    case "light": {
                        laf = new FlatLightLaf();
                        break;
                    }
                    case "system": {
                        useSystemTheme = true;
                        break;
                    }
                    default: {
                        FlatLaf.log("unknown theme id", themeFile);
                        laf = new FlatLightLaf();
                        break;
                    }
                }
            } else {
                laf = FlatLaf.loadLafFromThemeFile(themeFile);
            }
        }
        if (useSystemTheme) {
            FlatLaf.log(new Object[]{"System L&F is selected for theme ", theme});
            if (theme == FlatLafConfiguration.Theme.DARK) {
                UIManager.put("laf.dark", true);
            }
            UserInterface.setSystemLookAndFeel();
            return;
        }
        if (laf == null) {
            switch (theme) {
                case DARK: {
                    laf = new FlatDarkLaf();
                    break;
                }
                case LIGHT: {
                    laf = new FlatLightLaf();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(theme.name());
                }
            }
        }
        FlatLaf.setLaf(laf);
    }

    private static com.formdev.flatlaf.FlatLaf loadLafFromThemeFile(String themeFile) {
        com.formdev.flatlaf.FlatLaf flatLaf;
        FlatLaf.log("Loading L&F theme from", themeFile);
        FileInputStream in = new FileInputStream(themeFile);
        try {
            flatLaf = IntelliJTheme.createLaf(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                FlatLaf.log("Couldn't load IntelliJ theme from file:", themeFile, e);
                return null;
            }
        }
        in.close();
        return flatLaf;
    }

    private static void setLaf(com.formdev.flatlaf.FlatLaf lookAndFeel) {
        FlatLaf.log("Setting L&F:", lookAndFeel);
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception e) {
            FlatLaf.log("Couldn't set L&F", e);
        }
    }

    private static void setUIProperties(String uiPropertiesFile) {
        if (uiPropertiesFile == null) {
            FlatLaf.log("No UI properties file, skipping");
            return;
        }
        FlatLaf.log("Setting addon properties file: ", uiPropertiesFile);
        Addon.PROPERTIES_FILE = uiPropertiesFile;
    }

    private static void log(Object ... o) {
        U.log("[FlatLaf]", o);
    }
}

