/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ru.turikhay.tlauncher.bootstrap.exception.FatalExceptionType;
import ru.turikhay.tlauncher.bootstrap.meta.UpdateMeta;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.task.TaskListener;
import ru.turikhay.tlauncher.bootstrap.ui.Alert;
import ru.turikhay.tlauncher.bootstrap.ui.FatalExceptionHandler;
import ru.turikhay.tlauncher.bootstrap.ui.HeadlessInterface;
import ru.turikhay.tlauncher.bootstrap.ui.IInterface;
import ru.turikhay.tlauncher.bootstrap.ui.swing.SwingImageIcon;
import ru.turikhay.tlauncher.bootstrap.util.U;
import ru.turikhay.tlauncher.bootstrap.util.UTF8Control;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import shaded.org.apache.commons.lang3.builder.ToStringStyle;

public final class UserInterface
implements IInterface {
    public static final String DEFAULT_LOCALE = "en_US";
    static final int BORDER_SIZE = 20;
    static final int TASK_DEPTH = 2;
    private static final ResourceBundle resourceBundle;
    private static final NumberFormat PERCENT_FORMAT;
    private final JFrame frame;
    private final JPanel panel;
    private final JProgressBar progressBar;
    private final TaskListener<Object> taskListener;
    private Task<?> bindingTask;
    private static boolean headed;

    private UserInterface() throws HeadlessException {
        if (!UserInterface.isHeaded()) {
            throw new HeadlessException();
        }
        this.frame = new JFrame();
        this.frame.setIconImages(Stream.of("16", "64", "128", "256").map(r -> this.getClass().getResource("icon-" + r + ".png")).map(SwingImageIcon::loadImage).collect(Collectors.toList()));
        this.frame.setResizable(false);
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.frame.getContentPane().add(this.panel);
        BorderLayout layout = new BorderLayout();
        layout.setHgap(20);
        layout.setVgap(20);
        this.panel.setLayout(layout);
        this.panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(SwingImageIcon.loadIcon(this.getClass().getResource("icon-256.png"), 48, 48));
        iconLabel.setOpaque(false);
        iconLabel.setPreferredSize(new Dimension(48, 48));
        iconLabel.setVerticalAlignment(1);
        this.panel.add((Component)iconLabel, "West");
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(300, 0));
        this.progressBar.setOpaque(false);
        this.panel.add((Component)this.progressBar, "Center");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (UserInterface.this.bindingTask != null && UserInterface.this.bindingTask.isExecuting()) {
                    UserInterface.this.bindingTask.interrupt();
                }
            }
        });
        this.taskListener = new TaskListener<Object>(){

            @Override
            public void onTaskStarted(Task<?> task) {
                UserInterface.log(new Object[]{"Task started"});
                if (UserInterface.this.frame.isDisplayable()) {
                    UserInterface.this.frame.setLocationRelativeTo(null);
                    UserInterface.this.frame.setVisible(true);
                    UserInterface.this.progressBar.setValue(0);
                    UserInterface.this.progressBar.setIndeterminate(true);
                }
            }

            @Override
            public void onTaskUpdated(Task<?> task, double percentage) {
                if (UserInterface.this.frame.isDisplayable()) {
                    int newValue;
                    int n = newValue = percentage < 0.0 ? -1 : (int)(percentage * 100.0);
                    if (UserInterface.this.progressBar.getValue() - newValue != 0) {
                        UserInterface.log(new Object[]{"Task updated:", percentage});
                        Task<?> childTask = UserInterface.getChildTask(task, 2);
                        if (childTask.getProgress() < 0.0) {
                            UserInterface.this.progressBar.setIndeterminate(true);
                        } else {
                            UserInterface.this.progressBar.setIndeterminate(false);
                            UserInterface.this.progressBar.setValue(newValue);
                        }
                        String title = UserInterface.getLString("appname", "Bootstrap") + " :: " + (newValue == -1 ? "..." : PERCENT_FORMAT.format((double)newValue / 100.0)) + " :: " + UserInterface.getLocalizedTaskName(childTask);
                        UserInterface.this.frame.setTitle(title);
                    }
                    if (percentage == 1.0) {
                        this.onTaskSucceeded(task);
                    }
                }
            }

            @Override
            public void onTaskInterrupted(Task<?> task) {
                UserInterface.log(new Object[]{"Task interrupted"});
                if (UserInterface.this.frame.isDisplayable()) {
                    UserInterface.this.frame.dispose();
                }
            }

            @Override
            public void onTaskSucceeded(Task<?> task) {
                UserInterface.log(new Object[]{"Task succeed"});
                if (UserInterface.this.frame.isDisplayable()) {
                    UserInterface.this.progressBar.setValue(100);
                    UserInterface.this.frame.dispose();
                }
            }
        };
        this.frame.setTitle(UserInterface.getLString("appname", "Bootstrap"));
        this.frame.pack();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    @Override
    public void bindToTask(Task<?> task) {
        if (this.bindingTask != null && this.bindingTask.isExecuting()) {
            throw new IllegalStateException();
        }
        this.bindingTask = task;
        if (this.bindingTask != null) {
            this.bindingTask.addListener(this.taskListener);
        }
    }

    @Override
    public void dispose() {
        this.getFrame().dispose();
    }

    public UpdateMeta.ConnectionInterrupter createInterrupter() {
        return callback -> SwingUtilities.invokeLater(() -> {
            JButton button = new JButton(UserInterface.getLString("skip", "Skip"));
            button.addActionListener(e -> {
                this.panel.remove(button);
                this.panel.revalidate();
                this.panel.repaint();
                callback.onConnectionInterrupted();
            });
            this.panel.add((Component)button, "East");
            this.panel.revalidate();
            this.panel.repaint();
        });
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("task", this.bindingTask).build();
    }

    public static UserInterface createInterface() throws InterruptedException {
        AtomicReference ref = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(() -> ref.set(new UserInterface()));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("couldn't init UserInterface", e);
        }
        return (UserInterface)ref.get();
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static String getLocale() {
        return UserInterface.getLString("locale", DEFAULT_LOCALE);
    }

    public static String getLString(String key, String defaultValue) {
        ResourceBundle b = resourceBundle;
        return b == null ? defaultValue : (b.containsKey(key) ? b.getString(key) : defaultValue);
    }

    public static void showError(String message, Object textarea) {
        if (UserInterface.isHeaded()) {
            Alert.showError(message, textarea);
        } else {
            HeadlessInterface.printError(message, textarea);
        }
    }

    public static void showWarning(String message, Object textarea) {
        if (UserInterface.isHeaded()) {
            Alert.showWarning(message, textarea);
        } else {
            HeadlessInterface.printWarning(message, textarea);
        }
    }

    public static void showFatalError(FatalExceptionType type) {
        if (UserInterface.isHeaded()) {
            FatalExceptionHandler.handle(type);
        } else {
            HeadlessInterface.printFatalException(type);
        }
    }

    public static boolean isHeaded() {
        return headed;
    }

    public static void setHeaded(boolean head) {
        if (GraphicsEnvironment.isHeadless() && head) {
            throw new HeadlessException("current instance is headless");
        }
        headed = head;
    }

    static String getLocalizedTaskName(Task<?> task) {
        Objects.requireNonNull(task, "task");
        return UserInterface.getLString("loading.task." + task.getName(), task.getName());
    }

    static Task<?> getChildTask(Task<?> task, int depth) {
        Task<?> child = task.getBindingTask();
        if (child == null || depth == 0) {
            return task;
        }
        return UserInterface.getChildTask(child, depth - 1);
    }

    public static void setSystemLookAndFeel() {
        String systemLaf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(systemLaf);
        }
        catch (Exception e) {
            UserInterface.log("Couldn't set system L&F:", systemLaf, e);
        }
    }

    private static void log(Object ... o) {
        U.log("[UI]", o);
    }

    static {
        ResourceBundle b = null;
        try {
            b = ResourceBundle.getBundle("bootstrap", new UTF8Control());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        resourceBundle = b;
        PERCENT_FORMAT = NumberFormat.getPercentInstance();
        headed = !GraphicsEnvironment.isHeadless();
    }
}

