/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.turikhay.tlauncher.bootstrap.task.TaskInterruptedException;
import ru.turikhay.tlauncher.bootstrap.task.TaskListener;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import shaded.org.apache.commons.lang3.builder.ToStringStyle;

public abstract class Task<T>
implements Callable<T> {
    Task<?> bindingTask;
    Task<?> boundTask;
    private double boundTaskProgressStart;
    private double boundTaskProgressDelta;
    private final AtomicBoolean executing = new AtomicBoolean();
    private volatile boolean interrupted;
    private List<TaskListener<? super T>> listeners = new ArrayList<TaskListener<? super T>>();
    private final String name;
    private final String logPrefix;
    private double progress;

    public Task(String name) {
        this.name = name;
        this.logPrefix = "[" + this.getClass().getSimpleName() + ":" + name + ']';
    }

    public final String getName() {
        return this.name;
    }

    public final void addListener(TaskListener<? super T> listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
    }

    public final Task<?> getBindingTask() {
        return this.bindingTask;
    }

    public final void interrupt() {
        this.log("interrupted");
        this.interrupted = true;
        this.interrupted();
        if (this.bindingTask != null) {
            this.bindingTask.interrupt();
        }
    }

    protected void interrupted() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final T call() throws Exception {
        TaskListener<T> listener2222222;
        block20: {
            Exception e;
            block19: {
                if (this.executing.getAndSet(true)) {
                    throw new IllegalArgumentException("already executing");
                }
                this.listeners = Collections.unmodifiableList(this.listeners);
                for (TaskListener<T> listener2222222 : this.listeners) {
                    listener2222222.onTaskStarted(this);
                }
                e = null;
                try {
                    listener2222222 = this.execute();
                    if (!this.interrupted) break block19;
                }
                catch (InterruptedException inEx) {
                    try {
                        this.interrupted = true;
                        throw inEx;
                        catch (Exception ex) {
                            e = ex;
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.interrupted) {
                            this.log("interruption confirmed");
                            this.updateProgress(-1.0);
                            for (TaskListener<T> listener3 : this.listeners) {
                                listener3.onTaskInterrupted(this);
                            }
                        } else if (e == null) {
                            this.updateProgress(1.0);
                            this.log("Done!");
                            for (TaskListener<T> listener4 : this.listeners) {
                                listener4.onTaskSucceeded(this);
                            }
                        } else {
                            this.log("Failed:", e);
                            for (TaskListener<T> listener5 : this.listeners) {
                                listener5.onTaskErrored(this, e);
                            }
                        }
                        this.listeners = new ArrayList<TaskListener<? super T>>();
                        this.executing.set(false);
                        this.unbind();
                        throw throwable;
                    }
                }
                this.log("interruption confirmed");
                this.updateProgress(-1.0);
                for (TaskListener<T> listener6 : this.listeners) {
                    listener6.onTaskInterrupted(this);
                }
                break block20;
            }
            if (e == null) {
                this.updateProgress(1.0);
                this.log("Done!");
                for (TaskListener<T> listener7 : this.listeners) {
                    listener7.onTaskSucceeded(this);
                }
            } else {
                this.log("Failed:", e);
                for (TaskListener<T> listener8 : this.listeners) {
                    listener8.onTaskErrored(this, e);
                }
            }
        }
        this.listeners = new ArrayList<TaskListener<? super T>>();
        this.executing.set(false);
        this.unbind();
        return (T)listener2222222;
    }

    private void unbind() throws Exception {
        this.bindTo(null, 0.0, 0.0);
    }

    protected final <V> V bindTo(Task<V> task, double startProgress, double stopProgress) throws Exception {
        if (startProgress > stopProgress) {
            throw new IllegalArgumentException();
        }
        for (TaskListener<T> listener : this.listeners) {
            listener.onTaskBound(this, task);
        }
        if (task != null) {
            this.bindingTask = task;
            if (task.boundTask != null) {
                throw new IllegalStateException("task is already bound");
            }
            task.boundTask = this;
            task.boundTaskProgressStart = startProgress;
            task.boundTaskProgressDelta = stopProgress - startProgress;
            V result = task.call();
            this.updateProgress(stopProgress);
            this.unbind();
            this.checkInterrupted();
            return result;
        }
        if (this.bindingTask != null) {
            if (this.bindingTask.boundTask == this) {
                this.bindingTask.boundTask = null;
            }
            this.bindingTask = null;
        }
        return null;
    }

    public final double getProgress() {
        return this.progress;
    }

    protected final void updateProgress(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            percentage = -1.0;
        }
        this.progress = percentage;
        for (TaskListener<T> listener : this.listeners) {
            listener.onTaskUpdated(this, percentage);
        }
        if (this.boundTask != null) {
            this.boundTask.updateProgress(percentage == -1.0 ? this.boundTaskProgressStart : this.boundTaskProgressStart + percentage * this.boundTaskProgressDelta);
        }
    }

    public final boolean isExecuting() {
        return this.executing.get();
    }

    protected final void checkInterrupted() throws TaskInterruptedException {
        if (this.interrupted) {
            throw new TaskInterruptedException(this);
        }
    }

    protected final boolean isInterrupted() {
        return this.interrupted;
    }

    protected ToStringBuilder toStringBuilder() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", this.name);
    }

    public final String toString() {
        return this.toStringBuilder().build();
    }

    protected abstract T execute() throws Exception;

    protected void log(Object ... o) {
        U.log(this.logPrefix, o);
    }
}

