/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.pasta;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import ru.turikhay.tlauncher.bootstrap.Bootstrap;
import ru.turikhay.tlauncher.bootstrap.pasta.PastaException;
import ru.turikhay.tlauncher.bootstrap.pasta.PastaLink;
import ru.turikhay.tlauncher.bootstrap.pasta.TooManyRequests;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.event.EventBuilder;
import shaded.com.getsentry.raven.event.interfaces.ExceptionInterface;
import shaded.org.apache.commons.io.IOUtils;

public class Pasta {
    private static final String CREATE_PASTE_URL = "https://pasta.llaun.ch/create/v1";
    private final String content;

    public Pasta(String content) {
        this.content = content;
    }

    public PastaLink send() throws PastaException {
        URL url = this.createUrl();
        IOException e = null;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                return this.makeRequest(url);
            }
            catch (TooManyRequests tmr) {
                if (attempt < 3) {
                    int waitTime = (attempt > 1 ? 61 : 31) + new Random().nextInt(10);
                    try {
                        Thread.sleep((long)waitTime * 1000L);
                    }
                    catch (InterruptedException interrupted) {
                        throw new RuntimeException("interrupted", interrupted);
                    }
                }
                e = tmr;
                continue;
            }
            catch (IOException ioE) {
                Bootstrap.SENTRY.sendEvent(new EventBuilder().withLevel(Event.Level.ERROR).withMessage("pasta not sent").withSentryInterface(new ExceptionInterface(ioE)));
                e = ioE;
            }
        }
        throw new PastaException("Exhausted attempts limit", e);
    }

    private PastaLink makeRequest(URL url) throws IOException, PastaException {
        HttpURLConnection c = null;
        try {
            c = (HttpURLConnection)url.openConnection(U.getProxy());
            c.setConnectTimeout(3000);
            c.setReadTimeout(30000);
            c.setRequestProperty("Content-Type", "text/plain; charset=\"UTF-8\"");
            c.setRequestMethod("POST");
            c.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(c.getOutputStream(), StandardCharsets.UTF_8);
            IOUtils.copy((Reader)new StringReader(this.content), (Writer)writer);
            writer.close();
            String response = IOUtils.toString(c.getInputStream(), StandardCharsets.UTF_8);
            if (response.startsWith("http")) {
                PastaLink pastaLink = PastaLink.parse(response);
                return pastaLink;
            }
            try {
                throw new IOException("illegal response: \"" + response + '\"');
            }
            catch (IOException ioE) {
                if (c == null || c.getErrorStream() == null) {
                    throw ioE;
                }
                if (c.getResponseCode() == 429) {
                    throw new TooManyRequests(ioE);
                }
                String errorMessage = null;
                try {
                    errorMessage = IOUtils.toString(c.getErrorStream(), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    ioE.addSuppressed(e);
                }
                if (errorMessage != null) {
                    throw new IOException("Pasta returned error: \"" + errorMessage + "\"");
                }
                throw new IOException("Could not send and read error response from Pasta", ioE);
            }
        }
        finally {
            if (c != null) {
                c.disconnect();
            }
        }
    }

    private URL createUrl() {
        URL url;
        try {
            url = new URL(CREATE_PASTE_URL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("couldn't create url", e);
        }
        return url;
    }
}

