/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.meta;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.turikhay.tlauncher.bootstrap.json.Json;
import ru.turikhay.tlauncher.bootstrap.json.RemoteBootstrapDeserializer;
import ru.turikhay.tlauncher.bootstrap.json.RemoteLauncherDeserializer;
import ru.turikhay.tlauncher.bootstrap.json.UpdateDeserializer;
import ru.turikhay.tlauncher.bootstrap.meta.RemoteBootstrapMeta;
import ru.turikhay.tlauncher.bootstrap.meta.RemoteLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.transport.SignedStream;
import ru.turikhay.tlauncher.bootstrap.util.Compressor;
import ru.turikhay.tlauncher.repository.RepoPrefixV1;
import shaded.com.google.gson.Gson;
import shaded.com.google.gson.annotations.Expose;
import shaded.org.apache.commons.io.IOUtils;

public class UpdateMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateMeta.class);
    private static final int INITIAL_TIMEOUT = 1000;
    private static final int MAX_ATTEMPTS = 3;
    private static final int UPDATE_META_THREADS = 2;
    protected RemoteBootstrapMeta bootstrap;
    protected RemoteLauncherMeta launcher;
    protected RemoteLauncherMeta launcherBeta;
    @Expose
    protected String options;

    public static Task<UpdateMeta> fetchFor(final String shortBrand, ConnectionInterrupter interrupter) {
        Objects.requireNonNull(shortBrand, "brand");
        return new Task<UpdateMeta>("fetchUpdate"){

            @Override
            protected UpdateMeta execute() throws Exception {
                ExecutorService executor = Executors.newFixedThreadPool(2, new ThreadFactory(){
                    private final AtomicInteger i = new AtomicInteger();

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(null, r, "UpdateMeta-" + this.i.getAndIncrement());
                        t.setDaemon(true);
                        return t;
                    }
                });
                try {
                    UpdateMeta updateMeta = this.fetchUpdateMeta(executor);
                    return updateMeta;
                }
                catch (CancellationException e) {
                    LOGGER.warn("Update meta request was cancelled");
                    throw new UpdateMetaFetchFailed();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    LOGGER.error("Update meta request failed", cause);
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    throw e;
                }
                finally {
                    executor.shutdownNow();
                }
            }

            private UpdateMeta fetchUpdateMeta(ExecutorService executor) throws Exception {
                LOGGER.info("Requesting update for: {}", (Object)shortBrand);
                Gson gson = UpdateMeta.createGson(shortBrand);
                List<String> urlPrefixes = RepoPrefixV1.prefixesCdnFirst();
                String updatePath = "/brands/" + shortBrand + "/bootstrap.json.mgz.signed";
                int i = 1;
                while (i <= 3) {
                    int attempt = i++;
                    ArrayList futures = new ArrayList();
                    urlPrefixes.stream().map(urlPrefix -> {
                        String url = urlPrefix + updatePath;
                        return CompletableFuture.supplyAsync(() -> UpdateMeta.fetchAttempts(url, gson, attempt), executor);
                    }).collect(Collectors.toCollection(() -> futures));
                    CompletableFuture completed = new CompletableFuture();
                    futures.forEach(future -> future.thenAccept(completed::complete));
                    CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((v, t) -> completed.completeExceptionally(new UpdateMetaFetchFailed()));
                    try {
                        return (UpdateMeta)completed.join();
                    }
                    catch (CompletionException e) {
                        LOGGER.warn("Attempt {}: All update meta request were failed", (Object)attempt);
                    }
                }
                throw new UpdateMetaFetchFailed();
            }
        };
    }

    private static Gson createGson(String shortBrand) {
        return Json.build().registerTypeAdapter((Type)((Object)UpdateMeta.class), new UpdateDeserializer()).registerTypeAdapter((Type)((Object)RemoteLauncherMeta.class), new RemoteLauncherDeserializer(shortBrand)).registerTypeAdapter((Type)((Object)RemoteBootstrapMeta.class), new RemoteBootstrapDeserializer(shortBrand)).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static UpdateMeta fetchAttempts(String sUrl, Gson gson, int attempt) throws CompletionException {
        UpdateMeta updateMeta;
        URL url;
        try {
            url = new URL(sUrl);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Bad url: {}", (Object)sUrl, (Object)e);
            throw new CompletionException("bad url: " + sUrl, e);
        }
        LOGGER.info("{} ({} / {}): Requesting {}", url.getHost(), attempt, 3, url);
        InputStream stream = null;
        try {
            long start = System.currentTimeMillis();
            stream = UpdateMeta.setupConnection(url, attempt);
            if (url.getPath().endsWith(".signed")) {
                LOGGER.debug("{} ({} / {}): Requiring valid signature", url.getHost(), attempt, 3);
                stream = new SignedStream(stream);
            }
            UpdateMeta meta = UpdateMeta.fetchFrom(gson, Compressor.uncompressMarked(stream));
            if (stream instanceof SignedStream) {
                try {
                    ((SignedStream)stream).validateSignature();
                }
                catch (IOException e) {
                    LOGGER.error("{} ({} / {}): Bad signature", url.getHost(), attempt, 3, e);
                    throw e;
                }
            }
            if (Thread.interrupted()) {
                LOGGER.info("{} ({} / {}): Interrupted", url.getHost(), attempt, 3);
                throw new CompletionException(new InterruptedException());
            }
            LOGGER.info("{} ({} / {}): OK ({} ms)", url.getHost(), attempt, 3, System.currentTimeMillis() - start);
            updateMeta = meta;
        }
        catch (UnknownHostException e) {
            LOGGER.warn("{} ({} / {}): Unknown host", url.getHost(), attempt, 3);
            IOUtils.closeQuietly(stream);
        }
        catch (IOException e2) {
            LOGGER.warn("{} ({} / {}): Couldn't fetch", url.getHost(), attempt, 3, e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(stream);
        }
        IOUtils.closeQuietly(stream);
        return updateMeta;
        throw new CompletionException(new IOException("update meta is not available at " + url));
    }

    private static UpdateMeta fetchFrom(Gson gson, InputStream in) throws IOException {
        String read = null;
        try {
            read = IOUtils.toString(in, StandardCharsets.UTF_8);
            return gson.fromJson(read, UpdateMeta.class);
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                if (read == null) {
                    throw (IOException)e.getCause();
                }
                cause = e.getCause();
            }
            if (read == null) {
                throw e;
            }
            if (read.length() > 1000) {
                read = read.substring(0, 997) + "...";
            }
            throw new IOException("could not read: \"" + read + "\"", cause);
        }
    }

    public static UpdateMeta fetchFrom(InputStream in, String shortBrand) throws Exception {
        return UpdateMeta.fetchFrom(UpdateMeta.createGson(shortBrand), in);
    }

    private static InputStream setupConnection(URL url, int attempt) throws IOException {
        int timeout = attempt * 1000;
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(5 * timeout);
        return connection.getInputStream();
    }

    public UpdateMeta(RemoteBootstrapMeta bootstrap, RemoteLauncherMeta launcher, RemoteLauncherMeta launcherBeta, String options) {
        this.bootstrap = bootstrap;
        this.launcher = Objects.requireNonNull(launcher, "launcher");
        this.launcherBeta = launcherBeta;
        this.options = options;
    }

    public RemoteBootstrapMeta getBootstrap() {
        return this.bootstrap;
    }

    public RemoteLauncherMeta getLauncher(boolean beta) {
        return beta && this.launcherBeta != null ? this.launcherBeta : this.launcher;
    }

    public String getOptions() {
        return this.options;
    }

    static {
        Compressor.init();
    }

    public static class UpdateMetaFetchFailed
    extends Exception {
        UpdateMetaFetchFailed() {
            super("Couldn't fetch UpdateMeta");
        }
    }

    public static interface ConnectionInterrupter {
        public void mayInterruptConnection(Callback var1);

        public static interface Callback {
            public void onConnectionInterrupted();
        }
    }
}

