/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import ru.turikhay.tlauncher.bootstrap.util.OS;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.org.apache.commons.lang3.StringUtils;

public class ProcessStarter {
    public static ProcessBuilder startJarProcess(Path dir, Set<Path> classpath, String mainClass, List<String> jvmArgs, List<String> appArgs) throws IOException {
        Objects.requireNonNull(classpath, "classpath");
        Objects.requireNonNull(jvmArgs, "jvmArgs");
        Objects.requireNonNull(appArgs, "appArgs");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(ProcessStarter.getJavaExec());
        cmd.addAll(jvmArgs);
        cmd.add("-classpath");
        cmd.add(ProcessStarter.constructClassPath(classpath));
        cmd.add(mainClass);
        cmd.addAll(appArgs);
        return ProcessStarter.startProcess(dir, cmd);
    }

    private static ProcessBuilder startProcess(Path dir, List<String> cmd) throws IOException {
        U.log("[ProcessStarter]", "Starting process:", cmd);
        Objects.requireNonNull(dir, "dir");
        Objects.requireNonNull(cmd, "cmd");
        return new ProcessBuilder(new String[0]).command(cmd).directory(dir.toFile());
    }

    private static String getJavaExec() {
        char separator = File.separatorChar;
        String path = System.getProperty("java.home") + separator + "bin" + separator + "java";
        if (OS.WINDOWS.isCurrent()) {
            path = path + ".exe";
        }
        return path;
    }

    private static String constructClassPath(Set<Path> classpathList) throws IOException {
        StringBuilder classpathBuilder = new StringBuilder();
        for (Path classpathEntry : classpathList) {
            Objects.requireNonNull(classpathEntry, "classpathEntry");
            if (!Files.exists(classpathEntry, new LinkOption[0])) {
                throw new FileNotFoundException("classpath not found: " + classpathEntry.toAbsolutePath());
            }
            if (classpathBuilder.length() > 0) {
                classpathBuilder.append(File.pathSeparatorChar);
            }
            classpathBuilder.append(classpathEntry.toAbsolutePath());
        }
        return classpathBuilder.toString();
    }

    public static Set<Path> getDefinedClasspath() throws IOException {
        HashSet<Path> set = new HashSet<Path>();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)systemClassLoader).getURLs()) {
                Path systemClasspathEntry;
                try {
                    systemClasspathEntry = Paths.get(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
                if (!Files.exists(systemClasspathEntry, new LinkOption[0])) {
                    throw new FileNotFoundException("system classpath not found: " + systemClasspathEntry.toAbsolutePath());
                }
                set.add(systemClasspathEntry);
            }
        } else {
            String classPath = System.getProperty("tlauncher.bootstrap.classpath");
            if (classPath == null) {
                U.log("[WARNING] tlauncher.bootstrap.classpath is not defined", new Object[0]);
                return set;
            }
            for (String path : StringUtils.split(classPath, File.pathSeparatorChar)) {
                Path file = Paths.get(path, new String[0]);
                if (!Files.exists(file, new LinkOption[0])) {
                    throw new FileNotFoundException("predefined classpath entry not found: " + path + "(points to: " + file.toAbsolutePath() + ")");
                }
                set.add(file);
            }
        }
        return set;
    }
}

