/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.FallbackContainer;
import org.freedesktop.dbus.connections.GlobalHandler;
import org.freedesktop.dbus.connections.IDisconnectAction;
import org.freedesktop.dbus.connections.IDisconnectCallback;
import org.freedesktop.dbus.connections.IncomingMessageThread;
import org.freedesktop.dbus.connections.PendingCallbackManager;
import org.freedesktop.dbus.connections.ReceivingService;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.errors.UnknownObject;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.FatalDBusException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;
import org.freedesktop.dbus.messages.ObjectTree;
import org.freedesktop.dbus.utils.LoggingHelper;
import org.freedesktop.dbus.utils.NameableThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection
implements Closeable {
    public static final boolean FLOAT_SUPPORT = null != System.getenv("DBUS_JAVA_FLOATS");
    public static final Pattern BUSNAME_REGEX = Pattern.compile("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$");
    public static final Pattern CONNID_REGEX = Pattern.compile("^:[0-9]*\\.[0-9]*$");
    public static final Pattern OBJECT_REGEX_PATTERN = Pattern.compile("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$");
    public static final Pattern DOLLAR_PATTERN = Pattern.compile("[$]");
    public static final int MAX_ARRAY_LENGTH = 0x4000000;
    public static final int MAX_NAME_LENGTH = 255;
    @Deprecated(forRemoval=true, since="4.2.2 - 2022-12-23")
    public static final int TCP_CONNECT_TIMEOUT = 100000;
    @Deprecated(since="4.2.0 - 2022-08-04", forRemoval=true)
    public static final String TCP_ADDRESS_PROPERTY = "DBUS_TCP_SESSION";
    private static final Map<Thread, DBusCallInfo> INFOMAP = new ConcurrentHashMap<Thread, DBusCallInfo>();
    private static byte endianness = AbstractConnection.getSystemEndianness();
    private final Logger logger;
    private final ObjectTree objectTree;
    private final Map<String, ExportedObject> exportedObjects;
    private final Map<DBusInterface, RemoteObject> importedObjects;
    private final PendingCallbackManager callbackManager;
    private final FallbackContainer fallbackContainer;
    private final Queue<Error> pendingErrorQueue;
    private final Map<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>> handledSignals;
    private final Map<DBusMatchRule, Queue<DBusSigHandler<DBusSignal>>> genericHandledSignals;
    private final Map<Long, MethodCall> pendingCalls;
    private final IncomingMessageThread readerThread;
    private final ExecutorService senderService;
    private final ReceivingService receivingService;
    private final TransportBuilder transportBuilder;
    private boolean weakreferences = false;
    private volatile boolean disconnecting = false;
    private AbstractTransport transport;
    private Optional<IDisconnectCallback> disconnectCallback = Optional.ofNullable(null);

    protected AbstractConnection(TransportConfig _transportConfig, ReceivingServiceConfig _rsCfg) throws DBusException {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.exportedObjects = Collections.synchronizedMap(new HashMap());
        this.importedObjects = new ConcurrentHashMap<DBusInterface, RemoteObject>();
        this.exportedObjects.put(null, new ExportedObject(new GlobalHandler(this), this.weakreferences));
        this.handledSignals = new ConcurrentHashMap<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>>();
        this.genericHandledSignals = new ConcurrentHashMap<DBusMatchRule, Queue<DBusSigHandler<DBusSignal>>>();
        this.pendingCalls = Collections.synchronizedMap(new LinkedHashMap());
        this.callbackManager = new PendingCallbackManager();
        this.pendingErrorQueue = new ConcurrentLinkedQueue<Error>();
        this.receivingService = new ReceivingService(_rsCfg);
        this.senderService = Executors.newFixedThreadPool(1, new NameableThreadFactory("DBus Sender Thread-", false));
        this.objectTree = new ObjectTree();
        this.fallbackContainer = new FallbackContainer();
        this.transportBuilder = TransportBuilder.create(_transportConfig);
        this.readerThread = new IncomingMessageThread(this, this.transportBuilder.getAddress());
        try {
            this.transport = this.transportBuilder.build();
        }
        catch (IOException | DBusException _ex) {
            this.logger.debug("Error creating transport", _ex);
            if (_ex instanceof IOException) {
                this.internalDisconnect((IOException)_ex);
            }
            throw new DBusException("Failed to connect to bus: " + _ex.getMessage(), _ex);
        }
    }

    public abstract DBusInterface getExportedObject(String var1, String var2) throws DBusException;

    public abstract <T extends DBusInterface> T getExportedObject(String var1, String var2, Class<T> var3) throws DBusException;

    protected abstract <T extends DBusSignal> void removeSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    protected abstract <T extends DBusSignal> AutoCloseable addSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    protected abstract void removeGenericSigHandler(DBusMatchRule var1, DBusSigHandler<DBusSignal> var2) throws DBusException;

    protected abstract AutoCloseable addGenericSigHandler(DBusMatchRule var1, DBusSigHandler<DBusSignal> var2) throws DBusException;

    public abstract String getMachineId();

    protected <T extends DBusInterface> List<Class<?>> findMatchingTypes(Class<T> _type, List<String> _ifaces) {
        ArrayList ifcs = new ArrayList();
        if (_type == null) {
            block2: for (String iface : _ifaces) {
                this.logger.debug("Trying interface {}", (Object)iface);
                int j = 0;
                while (j >= 0) {
                    try {
                        Class<?> ifclass = Class.forName(iface);
                        if (ifcs.contains(ifclass)) continue block2;
                        ifcs.add(ifclass);
                        continue block2;
                    }
                    catch (Exception _ex) {
                        this.logger.trace("No class found for {}", (Object)iface, (Object)_ex);
                        j = iface.lastIndexOf(46);
                        char[] cs = iface.toCharArray();
                        if (j < 0) continue;
                        cs[j] = 36;
                        iface = String.valueOf(cs);
                    }
                }
            }
        } else {
            ifcs.add(_type);
        }
        return ifcs;
    }

    protected void listen() {
        this.readerThread.start();
    }

    public String getExportedObject(DBusInterface _interface) throws DBusException {
        String s;
        Optional<Map.Entry> foundInterface = this.getExportedObjects().entrySet().stream().filter(e -> _interface.equals(((ExportedObject)e.getValue()).getObject().get())).findFirst();
        if (foundInterface.isPresent()) {
            return (String)foundInterface.get().getKey();
        }
        RemoteObject rObj = this.getImportedObjects().get(_interface);
        if (rObj != null && (s = rObj.getObjectPath()) != null) {
            return s;
        }
        throw new DBusException("Not an object exported or imported by this connection");
    }

    @Deprecated(forRemoval=true, since="4.1.0")
    public void changeThreadCount(byte _newPoolSize) {
    }

    public void setWeakReferences(boolean _weakreferences) {
        this.weakreferences = _weakreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportObject(String _objectPath, DBusInterface _object) throws DBusException {
        if (null == _objectPath || _objectPath.isEmpty()) {
            throw new DBusException("Must Specify an Object Path");
        }
        if (_objectPath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(_objectPath).matches()) {
            throw new DBusException("Invalid object path: " + _objectPath);
        }
        Map<String, ExportedObject> map = this.getExportedObjects();
        synchronized (map) {
            if (null != this.getExportedObjects().get(_objectPath)) {
                throw new DBusException("Object already exported");
            }
            ExportedObject eo = new ExportedObject(_object, this.weakreferences);
            this.getExportedObjects().put(_objectPath, eo);
            ObjectTree objectTree = this.getObjectTree();
            synchronized (objectTree) {
                this.getObjectTree().add(_objectPath, eo, eo.getIntrospectiondata());
            }
        }
    }

    public void exportObject(DBusInterface _object) throws DBusException {
        Objects.requireNonNull(_object, "object must not be null");
        this.exportObject(_object.getObjectPath(), _object);
    }

    public void addFallback(String _objectPrefix, DBusInterface _object) throws DBusException {
        if (null == _objectPrefix || _objectPrefix.isEmpty()) {
            throw new DBusException("Must Specify an Object Path");
        }
        if (_objectPrefix.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(_objectPrefix).matches()) {
            throw new DBusException("Invalid object path: " + _objectPrefix);
        }
        ExportedObject eo = new ExportedObject(_object, this.weakreferences);
        this.fallbackContainer.add(_objectPrefix, eo);
    }

    public void removeFallback(String _objectprefix) {
        this.fallbackContainer.remove(_objectprefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unExportObject(String _objectpath) {
        Map<String, ExportedObject> map = this.getExportedObjects();
        synchronized (map) {
            this.getExportedObjects().remove(_objectpath);
            this.getObjectTree().remove(_objectpath);
        }
    }

    public void sendMessage(final Message _message) {
        if (!this.isConnected()) {
            throw new NotConnected("Cannot send message: Not connected");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractConnection.this.sendMessageInternally(_message);
            }
        };
        this.senderService.execute(runnable);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> _type, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        this.removeSigHandler(new DBusMatchRule(_type), _handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> _type, DBusInterface _object, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        String objectpath = this.getImportedObjects().get(_object).getObjectPath();
        if (objectpath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(objectpath).matches()) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(_type, null, objectpath), _handler);
    }

    public <T extends DBusSignal> AutoCloseable addSigHandler(Class<T> _type, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        return this.addSigHandler(new DBusMatchRule(_type), _handler);
    }

    public <T extends DBusSignal> AutoCloseable addSigHandler(Class<T> _type, DBusInterface _object, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        RemoteObject rObj = this.getImportedObjects().get(_object);
        if (rObj == null) {
            throw new DBusException("Not an object exported or imported by this connection");
        }
        String objectpath = rObj.getObjectPath();
        if (objectpath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(objectpath).matches()) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        return this.addSigHandler(new DBusMatchRule(_type, null, objectpath), _handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends DBusSignal> void addSigHandlerWithoutMatch(Class<? extends DBusSignal> _signal, DBusSigHandler<T> _handler) throws DBusException {
        DBusMatchRule rule = new DBusMatchRule(_signal);
        Map<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>> map = this.getHandledSignals();
        synchronized (map) {
            Queue<DBusSigHandler<? extends DBusSignal>> v = this.getHandledSignals().get(rule);
            if (null == v) {
                v = new ConcurrentLinkedQueue<DBusSigHandler<? extends DBusSignal>>();
                v.add(_handler);
                this.getHandledSignals().put(rule, v);
            } else {
                v.add(_handler);
            }
        }
    }

    protected synchronized void disconnect(IDisconnectAction _before, IDisconnectAction _after) {
        if (_before != null) {
            _before.perform();
        }
        this.internalDisconnect(null);
        if (_after != null) {
            _after.perform();
        }
    }

    protected final synchronized void internalDisconnect(IOException _connectionError) {
        if (!this.isConnected()) {
            this.logger.debug("Ignoring disconnect, already disconnected");
            return;
        }
        this.disconnecting = true;
        this.logger.debug("Disconnecting Abstract Connection");
        this.disconnectCallback.ifPresent(cb -> Optional.ofNullable(_connectionError).ifPresentOrElse(ex -> cb.disconnectOnError((IOException)ex), () -> cb.requestedDisconnect(null)));
        this.readerThread.terminate();
        this.receivingService.shutdown(10, TimeUnit.SECONDS);
        this.logger.debug("Notifying {} method call(s) to stop waiting for replies", (Object)this.getPendingCalls().size());
        IOException interrupt = _connectionError == null ? new IOException("Disconnecting") : _connectionError;
        for (MethodCall methodCall : this.getPendingCalls().values()) {
            try {
                methodCall.setReply(new Error(methodCall, interrupt));
            }
            catch (DBusException _ex) {
                this.logger.debug("Cannot set method reply to error", _ex);
            }
        }
        this.logger.debug("Shutting down SenderService");
        List<Runnable> remainingMsgsToSend = this.senderService.shutdownNow();
        if (_connectionError == null) {
            for (Runnable runnable : remainingMsgsToSend) {
                runnable.run();
            }
        } else if (!remainingMsgsToSend.isEmpty()) {
            this.logger.debug("Will not send {} messages due to connection closed by IOException", (Object)remainingMsgsToSend.size());
        }
        try {
            if (this.transport != null) {
                this.transport.close();
                this.transport = null;
            }
        }
        catch (IOException iOException) {
            this.logger.debug("Exception while disconnecting transport.", iOException);
        }
        this.receivingService.shutdownNow();
        this.disconnecting = false;
    }

    public synchronized void disconnect() {
        this.logger.debug("Disconnect called");
        this.internalDisconnect(null);
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    public <A> void callWithCallback(DBusInterface _object, String _m, CallbackHandler<A> _callback, Object ... _parameters) {
        this.logger.trace("callWithCallback({}, {}, {})", _object, _m, _callback);
        Class<?>[] types = AbstractConnection.createTypesArray(_parameters);
        RemoteObject ro = this.getImportedObjects().get(_object);
        try {
            Method me = null == ro.getInterface() ? _object.getClass().getMethod(_m, types) : ro.getInterface().getMethod(_m, types);
            RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 2, _callback, _parameters);
        }
        catch (DBusExecutionException _ex) {
            this.logger.debug("", _ex);
            throw _ex;
        }
        catch (Exception _ex) {
            this.logger.debug("", _ex);
            throw new DBusExecutionException(_ex.getMessage());
        }
    }

    public DBusAsyncReply<?> callMethodAsync(DBusInterface _object, String _method, Object ... _parameters) {
        Class<?>[] types = AbstractConnection.createTypesArray(_parameters);
        RemoteObject ro = this.getImportedObjects().get(_object);
        try {
            Method me = null == ro.getInterface() ? _object.getClass().getMethod(_method, types) : ro.getInterface().getMethod(_method, types);
            return (DBusAsyncReply)RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 1, null, _parameters);
        }
        catch (DBusExecutionException _ex) {
            this.logger.debug("", _ex);
            throw _ex;
        }
        catch (Exception _ex) {
            this.logger.debug("", _ex);
            throw new DBusExecutionException(_ex.getMessage());
        }
    }

    private static Class<?>[] createTypesArray(Object ... _parameters) {
        if (_parameters == null) {
            return null;
        }
        return (Class[])Arrays.stream(_parameters).filter(p -> p != null).map(p -> {
            if (List.class.isAssignableFrom(p.getClass())) {
                return List.class;
            }
            if (Map.class.isAssignableFrom(p.getClass())) {
                return Map.class;
            }
            if (Set.class.isAssignableFrom(p.getClass())) {
                return Set.class;
            }
            return p.getClass();
        }).toArray(Class[]::new);
    }

    protected void handleException(Message _methodOrSignal, DBusExecutionException _exception) {
        try {
            this.sendMessage(new Error(_methodOrSignal, _exception));
        }
        catch (DBusException _ex) {
            this.logger.warn("Exception caught while processing previous error.", _ex);
        }
    }

    void handleMessage(Message _message) throws DBusException {
        if (_message instanceof DBusSignal) {
            this.handleMessage((DBusSignal)_message, true);
        } else if (_message instanceof MethodCall) {
            this.handleMessage((MethodCall)_message);
        } else if (_message instanceof MethodReturn) {
            this.handleMessage((MethodReturn)_message);
        } else if (_message instanceof Error) {
            this.handleMessage((Error)_message);
        }
    }

    private void handleMessage(final MethodCall _methodCall) throws DBusException {
        ExportedObject exportObject;
        this.logger.debug("Handling incoming method call: {}", (Object)_methodCall);
        Method meth = null;
        DBusInterface o = null;
        if (null == _methodCall.getInterface() || _methodCall.getInterface().equals("org.freedesktop.DBus.Peer") || _methodCall.getInterface().equals("org.freedesktop.DBus.Introspectable")) {
            exportObject = this.getExportedObjects().get(null);
            if (null != exportObject && null == exportObject.getObject().get()) {
                this.unExportObject(null);
                exportObject = null;
            }
            if (null != exportObject) {
                meth = exportObject.getMethods().get(new MethodTuple(_methodCall.getName(), _methodCall.getSig()));
            }
            if (null != meth) {
                o = new GlobalHandler(this, _methodCall.getPath());
            }
        }
        if (null == o) {
            exportObject = this.getExportedObjects().get(_methodCall.getPath());
            if (exportObject != null && exportObject.getObject().get() == null) {
                this.logger.info("Unexporting {} implicitly", (Object)_methodCall.getPath());
                this.unExportObject(_methodCall.getPath());
                exportObject = null;
            }
            if (null == exportObject) {
                exportObject = this.fallbackContainer.get(_methodCall.getPath());
            }
            if (null == exportObject) {
                this.sendMessage(new Error(_methodCall, new UnknownObject(_methodCall.getPath() + " is not an object provided by this process.")));
                return;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Searching for method {}  with signature {}", (Object)_methodCall.getName(), (Object)_methodCall.getSig());
                this.logger.trace("List of methods on {}: ", (Object)exportObject);
                for (MethodTuple mt : exportObject.getMethods().keySet()) {
                    this.logger.trace("   {} => {}", (Object)mt, (Object)exportObject.getMethods().get(mt));
                }
            }
            if (null == (meth = exportObject.getMethods().get(new MethodTuple(_methodCall.getName(), _methodCall.getSig())))) {
                this.sendMessage(new Error(_methodCall, new UnknownMethod(String.format("The method `%s.%s' does not exist on this object.", _methodCall.getInterface(), _methodCall.getName()))));
                return;
            }
            o = exportObject.getObject().get();
        }
        if (ExportedObject.isExcluded(meth)) {
            this.sendMessage(new Error(_methodCall, new UnknownMethod(String.format("The method `%s.%s' is not exported.", _methodCall.getInterface(), _methodCall.getName()))));
            return;
        }
        final Method me = meth;
        final GlobalHandler ob = o;
        final boolean noreply = 1 == (_methodCall.getFlags() & 1);
        final DBusCallInfo info = new DBusCallInfo(_methodCall);
        final AbstractConnection conn = this;
        this.logger.trace("Adding Runnable for method {}", (Object)meth);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AbstractConnection.this.logger.debug("Running method {} for remote call", (Object)me);
                try {
                    Type[] ts = me.getGenericParameterTypes();
                    _methodCall.setArgs(Marshalling.deSerializeParameters(_methodCall.getParameters(), ts, conn));
                    LoggingHelper.logIf(AbstractConnection.this.logger.isTraceEnabled(), () -> {
                        try {
                            AbstractConnection.this.logger.trace("Deserialised {} to types {}", (Object)Arrays.deepToString(_methodCall.getParameters()), (Object)Arrays.deepToString(ts));
                        }
                        catch (Exception _ex) {
                            AbstractConnection.this.logger.trace("Error getting method call parameters", _ex);
                        }
                    });
                }
                catch (Exception _ex) {
                    AbstractConnection.this.logger.debug("", _ex);
                    AbstractConnection.this.handleException(_methodCall, new UnknownMethod("Failure in de-serializing message: " + _ex));
                    return;
                }
                try {
                    Object result;
                    INFOMAP.put(Thread.currentThread(), info);
                    try {
                        LoggingHelper.logIf(AbstractConnection.this.logger.isTraceEnabled(), () -> {
                            try {
                                AbstractConnection.this.logger.trace("Invoking Method: {} on {} with parameters {}", me, ob, Arrays.deepToString(_methodCall.getParameters()));
                            }
                            catch (DBusException _ex) {
                                AbstractConnection.this.logger.trace("Error getting parameters from method call", _ex);
                            }
                        });
                        result = me.invoke(ob, _methodCall.getParameters());
                    }
                    catch (InvocationTargetException _ex) {
                        AbstractConnection.this.logger.debug(_ex.getMessage(), _ex);
                        throw _ex.getCause();
                    }
                    INFOMAP.remove(Thread.currentThread());
                    if (!noreply) {
                        MethodReturn reply;
                        if (Void.TYPE.equals(me.getReturnType())) {
                            reply = new MethodReturn(_methodCall, null, new Object[0]);
                        } else {
                            StringBuffer sb = new StringBuffer();
                            for (String s : Marshalling.getDBusType(me.getGenericReturnType())) {
                                sb.append(s);
                            }
                            Object[] nr = Marshalling.convertParameters(new Object[]{result}, new Type[]{me.getGenericReturnType()}, conn);
                            reply = new MethodReturn(_methodCall, sb.toString(), nr);
                        }
                        conn.sendMessage(reply);
                    }
                }
                catch (DBusExecutionException _ex) {
                    AbstractConnection.this.logger.debug("", _ex);
                    AbstractConnection.this.handleException(_methodCall, _ex);
                }
                catch (Throwable _ex) {
                    AbstractConnection.this.logger.debug("", _ex);
                    AbstractConnection.this.handleException(_methodCall, new DBusExecutionException(String.format("Error Executing Method %s.%s: %s", _methodCall.getInterface(), _methodCall.getName(), _ex.getMessage())));
                }
            }
        };
        this.receivingService.execMethodCallHandler(r);
    }

    private void handleMessage(DBusSignal _signal, boolean _useThreadPool) {
        Runnable command;
        this.logger.debug("Handling incoming signal: {}", (Object)_signal);
        ArrayList handlers = new ArrayList();
        ArrayList genericHandlers = new ArrayList();
        for (Map.Entry<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>> entry : this.getHandledSignals().entrySet()) {
            if (!entry.getKey().matches(_signal, false)) continue;
            handlers.addAll(entry.getValue());
        }
        for (Map.Entry<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>> entry : this.getGenericHandledSignals().entrySet()) {
            if (!entry.getKey().matches(_signal, false)) continue;
            genericHandlers.addAll(entry.getValue());
        }
        if (handlers.isEmpty() && genericHandlers.isEmpty()) {
            return;
        }
        AbstractConnection conn = this;
        for (DBusSigHandler h : handlers) {
            this.logger.trace("Adding Runnable for signal {} with handler {}", (Object)_signal, (Object)h);
            command = () -> {
                try {
                    DBusSignal rs = _signal.getClass().equals(DBusSignal.class) ? _signal.createReal(conn) : _signal;
                    if (rs == null) {
                        return;
                    }
                    h.handle(rs);
                }
                catch (DBusException _ex) {
                    this.logger.warn("Exception while running signal handler '{}' for signal '{}':", h, _signal, _ex);
                    this.handleException(_signal, new DBusExecutionException("Error handling signal " + _signal.getInterface() + "." + _signal.getName() + ": " + _ex.getMessage()));
                }
            };
            if (_useThreadPool) {
                this.receivingService.execSignalHandler(command);
                continue;
            }
            command.run();
        }
        for (DBusSigHandler h : genericHandlers) {
            this.logger.trace("Adding Runnable for signal {} with handler {}", (Object)_signal, (Object)h);
            command = () -> h.handle(_signal);
            if (_useThreadPool) {
                this.receivingService.execSignalHandler(command);
                continue;
            }
            command.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final Error _err) {
        this.logger.debug("Handling incoming error: {}", (Object)_err);
        MethodCall m = null;
        if (this.getPendingCalls() == null) {
            return;
        }
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            if (this.getPendingCalls().containsKey(_err.getReplySerial())) {
                m = this.getPendingCalls().remove(_err.getReplySerial());
            }
        }
        if (m != null) {
            m.setReply(_err);
            CallbackHandler<? extends Object> cbh = this.callbackManager.removeCallback(m);
            this.logger.trace("{} = pendingCallbacks.remove({})", (Object)cbh, (Object)m);
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                this.logger.trace("Adding Error Runnable with callback handler {}", (Object)fcbh);
                Runnable command = new Runnable(){

                    @Override
                    public synchronized void run() {
                        try {
                            AbstractConnection.this.logger.trace("Running Error Callback for {}", (Object)_err);
                            DBusCallInfo info = new DBusCallInfo(_err);
                            INFOMAP.put(Thread.currentThread(), info);
                            fcbh.handleError(_err.getException());
                            INFOMAP.remove(Thread.currentThread());
                        }
                        catch (Exception _ex) {
                            AbstractConnection.this.logger.debug("Exception while running error callback.", _ex);
                        }
                    }
                };
                this.receivingService.execErrorHandler(command);
            }
        } else {
            this.getPendingErrorQueue().add(_err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final MethodReturn _mr) {
        this.logger.debug("Handling incoming method return: {}", (Object)_mr);
        MethodCall m = null;
        if (null == this.getPendingCalls()) {
            return;
        }
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            if (this.getPendingCalls().containsKey(_mr.getReplySerial())) {
                m = this.getPendingCalls().remove(_mr.getReplySerial());
            }
        }
        if (null != m) {
            m.setReply(_mr);
            _mr.setCall(m);
            CallbackHandler<? extends Object> cbh = this.callbackManager.getCallback(m);
            DBusAsyncReply<?> asr = this.callbackManager.getCallbackReply(m);
            this.callbackManager.removeCallback(m);
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                final DBusAsyncReply<?> fasr = asr;
                if (fasr == null) {
                    this.logger.debug("Cannot add runnable for method, given method callback was null");
                    return;
                }
                this.logger.trace("Adding Runnable for method {} with callback handler {}", (Object)fcbh, (Object)fasr.getMethod());
                Runnable r = new Runnable(){

                    @Override
                    public synchronized void run() {
                        try {
                            AbstractConnection.this.logger.trace("Running Callback for {}", (Object)_mr);
                            DBusCallInfo info = new DBusCallInfo(_mr);
                            INFOMAP.put(Thread.currentThread(), info);
                            Object convertRV = RemoteInvocationHandler.convertRV(_mr.getSig(), _mr.getParameters(), fasr.getMethod(), fasr.getConnection());
                            fcbh.handle(convertRV);
                            INFOMAP.remove(Thread.currentThread());
                        }
                        catch (Exception _ex) {
                            AbstractConnection.this.logger.debug("Exception while running callback.", _ex);
                        }
                    }
                };
                this.receivingService.execMethodReturnHandler(r);
            }
        } else {
            try {
                this.sendMessage(new Error(_mr, new DBusExecutionException("Spurious reply. No message with the given serial id was awaiting a reply.")));
            }
            catch (DBusException _exDe) {
                this.logger.trace("Could not send error message", _exDe);
            }
        }
    }

    public void queueCallback(MethodCall _call, Method _method, CallbackHandler<?> _callback) {
        this.callbackManager.queueCallback(_call, _method, _callback, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageInternally(Message _message) {
        block19: {
            try {
                if (!this.isConnected()) {
                    throw new NotConnected("Disconnected");
                }
                if (_message instanceof DBusSignal) {
                    ((DBusSignal)_message).appendbody(this);
                }
                if (_message instanceof MethodCall && 0 == (_message.getFlags() & 1) && null != this.getPendingCalls()) {
                    Map<Long, MethodCall> map = this.getPendingCalls();
                    synchronized (map) {
                        this.getPendingCalls().put(_message.getSerial(), (MethodCall)_message);
                    }
                }
                this.transport.writeMessage(_message);
            }
            catch (Exception _ex) {
                this.logger.trace("Exception while sending message.", _ex);
                if (_message instanceof MethodCall && _ex instanceof DBusExecutionException) {
                    try {
                        ((MethodCall)_message).setReply(new Error(_message, _ex));
                    }
                    catch (DBusException _exDe) {
                        this.logger.trace("Could not set message reply", _exDe);
                    }
                } else if (_message instanceof MethodCall) {
                    try {
                        this.logger.info("Setting reply to {} as an error", (Object)_message);
                        ((MethodCall)_message).setReply(new Error(_message, new DBusExecutionException("Message Failed to Send: " + _ex.getMessage())));
                    }
                    catch (DBusException _exDe) {
                        this.logger.trace("Could not set message reply", _exDe);
                    }
                } else if (_message instanceof MethodReturn) {
                    try {
                        this.transport.writeMessage(new Error(_message, _ex));
                    }
                    catch (IOException | DBusException _exIo) {
                        this.logger.debug("Error writing method return to transport", _exIo);
                    }
                }
                if (!(_ex instanceof IOException)) break block19;
                this.logger.debug("Fatal IOException while sending message, disconnecting", _ex);
                this.internalDisconnect((IOException)_ex);
            }
        }
    }

    Message readIncoming() throws DBusException {
        Message m;
        block5: {
            if (!this.isConnected()) {
                return null;
            }
            m = null;
            try {
                m = this.transport.readMessage();
            }
            catch (IOException _exIo) {
                if (_exIo instanceof EOFException || _exIo instanceof ClosedByInterruptException) {
                    this.disconnectCallback.ifPresent(cb -> cb.clientDisconnect());
                    if (this.disconnecting || this.transportBuilder.getAddress().isListeningSocket()) {
                        return null;
                    }
                }
                if (!this.isConnected()) break block5;
                throw new FatalDBusException(_exIo);
            }
        }
        return m;
    }

    protected synchronized Map<String, ExportedObject> getExportedObjects() {
        return this.exportedObjects;
    }

    FallbackContainer getFallbackContainer() {
        return this.fallbackContainer;
    }

    public static DBusCallInfo getCallInfo() {
        return INFOMAP.get(Thread.currentThread());
    }

    public DBusExecutionException getError() {
        Error poll = this.getPendingErrorQueue().poll();
        if (poll != null) {
            return poll.getException();
        }
        return null;
    }

    public BusAddress getAddress() {
        return this.transportBuilder.getAddress();
    }

    public boolean isConnected() {
        return this.transport != null && this.transport.isConnected();
    }

    protected Queue<Error> getPendingErrorQueue() {
        return this.pendingErrorQueue;
    }

    protected Map<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>> getHandledSignals() {
        return this.handledSignals;
    }

    protected Map<DBusMatchRule, Queue<DBusSigHandler<DBusSignal>>> getGenericHandledSignals() {
        return this.genericHandledSignals;
    }

    protected Map<Long, MethodCall> getPendingCalls() {
        return this.pendingCalls;
    }

    protected Map<DBusInterface, RemoteObject> getImportedObjects() {
        return this.importedObjects;
    }

    protected ObjectTree getObjectTree() {
        return this.objectTree;
    }

    public static void setEndianness(byte _b) {
        if (_b == 66 || _b == 108) {
            endianness = _b;
        }
    }

    public static byte getEndianness() {
        return endianness;
    }

    public static byte getSystemEndianness() {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? (byte)66 : 108;
    }

    public IDisconnectCallback getDisconnectCallback() {
        return this.disconnectCallback.orElse(null);
    }

    public void setDisconnectCallback(IDisconnectCallback _disconnectCallback) {
        this.disconnectCallback = Optional.ofNullable(_disconnectCallback);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[address=" + this.transportBuilder.getAddress() + "]";
    }
}

